﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

namespace VIRP.EFR.UTIL
{
    public class StringUtility
    {
        public static string GetPaddedString(string input, int totalLength)
        {
            StringBuilder builder = new StringBuilder(totalLength);
            for (int idx = 0; idx < totalLength; idx++)
                builder.Append(input.Length < totalLength ? input[idx] : ' ');

            return builder.ToString();
        }

        public static T? TryGetValueFromString<T>(string input)
            where T : struct, IConvertible
        {
            if (string.IsNullOrEmpty(input))
                return null;

            var converter = TypeDescriptor.GetConverter(typeof(T));

            if (converter != null)
                return (T)converter.ConvertFromString(input);

            return null;
        }

        public static string GetCollectionAsSafeDelimitedString<T>(IReadOnlyList<T> collection)
            where T : struct
        {
            if (collection == null || !collection.Any())
                return null;

            return string.Join(",", collection);
        }
    }
}
